/* vi: set sw=4 ts=4: */
/*
 * pid file routines
 *
 * Copyright (C) 2007 by Stephane Billiart <stephane.billiart@gmail.com>
 *
 * Licensed under GPLv2 or later, see file LICENSE in this source tree.
 */

/* Override ENABLE_FEATURE_PIDFILE */
#define WANT_PIDFILE 1
#include "libbb.h"
#include "tplink_debug.h"

smallint wrote_pidfile;

void FAST_FUNC write_pidfile(const char *path)
{
	int pid_fd;
	char *end;
	char buf[sizeof(int)*3 + 2];
	struct stat sb;

	if (!path)
		return;
	/* we will overwrite stale pidfile and if it exists, 
	 *it means another udhcpc si running, so we exit
     *add by chengPan
	*/
	pid_fd = open(path, O_WRONLY|O_CREAT|O_TRUNC | O_EXCL, 0666);
	if (pid_fd < 0)
	{
		/* add by ChengPan */
		DEBUG_TO_FILE("\n*************************************\n"
					  "%s : already exists !!!\n"
					  "*************************************\n", path);
		exit(0);
	}

	/* path can be "/dev/null"! Test for such cases */
	wrote_pidfile = (fstat(pid_fd, &sb) == 0) && S_ISREG(sb.st_mode);

	if (wrote_pidfile) {
		/* few bytes larger, but doesn't use stdio */
		end = utoa_to_buf(getpid(), buf, sizeof(buf));
		*end = '\n';
		full_write(pid_fd, buf, end - buf + 1);
	}
	close(pid_fd);
}
